/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import net.ftb.data.Settings;
import net.ftb.log.Logger;
import net.ftb.util.ErrorUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.TrackerUtils;
import net.ftb.util.winreg.JavaInfo;

public class LaunchFrameHelpers {
    public static void printInfo() {
        JavaInfo java;
        Logger.logInfo("FTBLaunch starting up (version 1.4.3 - by greg0ree Build: 10403)");
        Logger.logInfo("Java version: " + System.getProperty("java.version"));
        Logger.logInfo("Java vendor: " + System.getProperty("java.vendor"));
        Logger.logInfo("Java home: " + System.getProperty("java.home"));
        Logger.logInfo("Java specification: " + System.getProperty("java.vm.specification.name") + " version: " + System.getProperty("java.vm.specification.version") + " by " + System.getProperty("java.vm.specification.vendor"));
        Logger.logInfo("Java vm: " + System.getProperty("java.vm.name") + " version: " + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        Logger.logInfo("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + (OSUtils.is64BitOS() ? "64-bit" : "32-bit") + ")");
        Logger.logInfo("Launcher Install Dir: " + Settings.getSettings().getInstallPath());
        Logger.logInfo("System memory: " + OSUtils.getOSFreeMemory() + "M free, " + OSUtils.getOSTotalMemory() + "M total");
        String selectedJavaPath = Settings.getSettings().getJavaPath();
        if (!selectedJavaPath.equals(Settings.getSettings().getDefaultJavaPath())) {
            Logger.logInfo("Using Java path entered by user: " + selectedJavaPath);
        }
        if (!OSUtils.is64BitOS()) {
            Logger.logError("32-bit operating system. 64-bit is required for most mod packs. If you have issues, please try the FTB Lite 2 pack.");
        }
        if (OSUtils.is64BitOS() && !Settings.getSettings().getCurrentJava().is64bits) {
            Logger.logError("32-bit Java in 64-bit operating system. 64-bit Java is required for most mod packs. If you have issues, please try the FTB Lite 2 pack.");
        }
        if ((java = Settings.getSettings().getCurrentJava()).getMajor() < 1 || java.getMajor() == 1 && java.getMinor() < 7) {
            Logger.logError("Java 6 detected. Java 7 is recommended for most mod packs.");
        }
    }

    public static void googleAnalytics() {
        block13: {
            File credits = new File(OSUtils.getDynamicStorageLocation(), "credits.txt");
            try {
                if (!credits.exists()) {
                    FileOutputStream fos = new FileOutputStream(credits);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write("FTB Launcher and Modpack Credits " + System.getProperty("line.separator"));
                    osw.write("-------------------------------" + System.getProperty("line.separator"));
                    osw.write("Launcher Developers:" + System.getProperty("line.separator"));
                    osw.write("jjw123" + System.getProperty("line.separator"));
                    osw.write("unv_annihilator" + System.getProperty("line.separator"));
                    osw.write("ProgWML6" + System.getProperty("line.separator"));
                    osw.write("Major Launcher Dev Contributors" + System.getProperty("line.separator"));
                    osw.write("LexManos" + System.getProperty("line.separator"));
                    osw.write("IoP" + System.getProperty("line.separator") + System.getProperty("line.separator"));
                    osw.write("Viper-7" + System.getProperty("line.separator") + System.getProperty("line.separator"));
                    osw.write("Vbitz" + System.getProperty("line.separator") + System.getProperty("line.separator"));
                    osw.write("Web Developers:" + System.getProperty("line.separator"));
                    osw.write("Captainnana" + System.getProperty("line.separator"));
                    osw.write("Rob" + System.getProperty("line.separator") + System.getProperty("line.separator"));
                    osw.write("Modpack Team:" + System.getProperty("line.separator"));
                    osw.write("Lathanael" + System.getProperty("line.separator"));
                    osw.write("Watchful11" + System.getProperty("line.separator"));
                    osw.write("Jadedcat" + System.getProperty("line.separator"));
                    osw.write("Eyamaz" + System.getProperty("line.separator"));
                    osw.flush();
                    osw.close();
                    TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Unique User (Credits)");
                }
            }
            catch (FileNotFoundException e1) {
                Logger.logError(e1.getMessage());
            }
            catch (IOException e1) {
                Logger.logError(e1.getMessage());
            }
            if (!Settings.getSettings().getLoaded()) {
                TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "OS: " + System.getProperty("os.name") + " : " + System.getProperty("os.arch"));
                TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Unique User (Settings)");
                Settings.getSettings().setLoaded(true);
            }
            File stamp = new File(OSUtils.getDynamicStorageLocation(), "stamp");
            long unixTime = System.currentTimeMillis() / 1000L;
            long unixts = 0L;
            try {
                int content;
                if (!stamp.exists()) {
                    FileOutputStream fos = new FileOutputStream(stamp);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write(String.valueOf(unixTime));
                    osw.flush();
                    osw.close();
                    Logger.logInfo("Reporting daily use");
                    TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Daily User (Flat)");
                    break block13;
                }
                FileInputStream fis = new FileInputStream(stamp);
                StringBuilder timeBuilder = new StringBuilder();
                while ((content = fis.read()) != -1) {
                    char c = (char)content;
                    timeBuilder.append(String.valueOf(c));
                }
                String time = timeBuilder.toString();
                try {
                    unixts = Long.valueOf(time);
                }
                catch (NumberFormatException e) {
                    Logger.logWarn("Malformed stamp-file. Will be fixed automatically");
                }
                if ((unixts += 86400L) < unixTime) {
                    FileOutputStream fos = new FileOutputStream(stamp);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write(String.valueOf(unixTime));
                    osw.flush();
                    osw.close();
                    Logger.logInfo("Reporting daily use");
                    TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Daily User (Flat)");
                }
                fis.close();
            }
            catch (FileNotFoundException e1) {
                Logger.logError(e1.getMessage());
            }
            catch (IOException e1) {
                Logger.logError(e1.getMessage());
            }
        }
    }

    public static void tossNag(String setting, String message) {
        if (!Settings.getSettings().getBoolean(setting)) {
            int result = ErrorUtils.tossOKIgnoreDialog(message, 2);
            if (result != 0 && result != -1) {
                Settings.getSettings().setBoolean(setting, true);
                Settings.getSettings().save();
            }
        } else {
            Logger.logDebug("ignored: " + setting);
        }
    }
}

